/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszsenchantments.Registries;
import com.majruszsenchantments.configs.VampirismDoubleConfig;
import com.mlib.EquipmentSlots;
import com.mlib.Random;
import com.mlib.Utility;
import com.mlib.config.ConfigGroup;
import com.mlib.config.IConfigurable;
import com.mlib.contexts.OnDamaged;
import com.mlib.contexts.OnEnchantmentAvailabilityCheck;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.effects.ParticleHandler;
import com.mlib.effects.SoundHandler;
import com.mlib.enchantments.CustomEnchantment;
import com.mlib.math.AnyPos;
import com.mlib.mobeffects.MobEffectHelper;
import com.mlib.modhelper.AutoInstance;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class LeechEnchantment
extends CustomEnchantment {
    public LeechEnchantment() {
        this.rarity(Enchantment.Rarity.RARE).category(Registries.MELEE_MINECRAFT).slots(EquipmentSlots.MAINHAND).minLevelCost(level -> 20).maxLevelCost(level -> 40);
    }

    @AutoInstance
    public static class Handler {
        final VampirismDoubleConfig healthChance = new VampirismDoubleConfig(0.1, 0.1);
        final VampirismDoubleConfig hungerChance = new VampirismDoubleConfig(0.1, 0.1);
        final VampirismDoubleConfig effectChance = new VampirismDoubleConfig(0.1, 0.1);
        final Supplier<LeechEnchantment> enchantment = Registries.LEECH;

        public Handler() {
            ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.ENCHANTMENT).name("Leech").comment("Gives a chance to steal positive effects, health and hunger points from enemies.");
            OnEnchantmentAvailabilityCheck.listen((Consumer)OnEnchantmentAvailabilityCheck.ENABLE).addCondition(OnEnchantmentAvailabilityCheck.is(this.enchantment)).addCondition(OnEnchantmentAvailabilityCheck.excludable()).insertTo(group);
            OnDamaged.listen(this::tryToLeechAnything).addCondition(Condition.isServer()).addCondition(Condition.hasEnchantment(this.enchantment, data -> data.attacker)).addCondition(OnDamaged.dealtAnyDamage()).addConfig((IConfigurable)this.healthChance.name("HealthChance").comment("Chance to steal 1 health point from the target.")).addConfig((IConfigurable)this.hungerChance.name("HungerChance").comment("Chance to steal 1 hunger point from the target.")).addConfig((IConfigurable)this.effectChance.name("EffectChance").comment("Chance to steal 1 random positive effect from the target.")).insertTo(group);
        }

        private void tryToLeechAnything(OnDamaged.Data data) {
            assert (data.attacker != null && data.getLevel() != null);
            boolean leechedAnything = this.tryToLeech(this.healthChance, this::leechHealth, data);
            leechedAnything = this.tryToLeech(this.hungerChance, this::leechHunger, data) || leechedAnything;
            boolean bl = leechedAnything = this.tryToLeech(this.effectChance, this::leechEffect, data) || leechedAnything;
            if (leechedAnything) {
                this.spawnEffects(data.getServerLevel(), data.attacker, data.target);
            }
        }

        private boolean tryToLeech(VampirismDoubleConfig chanceConfig, BiFunction<LivingEntity, LivingEntity, Boolean> function, OnDamaged.Data data) {
            return Random.tryChance((double)chanceConfig.getTotalChance(data.attacker)) ? function.apply(data.attacker, data.target) : false;
        }

        private boolean leechHealth(LivingEntity attacker, LivingEntity target) {
            target.m_6469_(DamageSource.f_19319_, 1.0f);
            attacker.m_5634_(1.0f);
            return true;
        }

        private boolean leechHunger(LivingEntity attacker, LivingEntity target) {
            if (attacker instanceof Player) {
                Player playerAttacker = (Player)attacker;
                FoodData attackerFood = playerAttacker.m_36324_();
                attackerFood.m_38705_(Math.min(attackerFood.m_38702_() + 1, 20));
                if (target instanceof Player) {
                    Player playerTarget = (Player)target;
                    FoodData targetFood = playerTarget.m_36324_();
                    targetFood.m_38705_(Math.max(targetFood.m_38702_() - 1, 0));
                }
                return true;
            }
            return false;
        }

        private boolean leechEffect(LivingEntity attacker, LivingEntity target) {
            for (MobEffectInstance effectInstance : target.m_21220_()) {
                MobEffect effect = effectInstance.m_19544_();
                if (!effect.m_19486_()) continue;
                int maximumDuration = Math.min(Utility.secondsToTicks((double)30.0), effectInstance.m_19557_());
                MobEffectHelper.tryToApply((LivingEntity)attacker, (MobEffect)effect, (int)maximumDuration, (int)effectInstance.m_19564_());
                target.m_21195_(effect);
                return true;
            }
            return false;
        }

        private void spawnEffects(ServerLevel level, LivingEntity attacker, LivingEntity target) {
            Vec3 from = AnyPos.from((Vec3)attacker.m_20182_()).add((Number)0.0, (Number)((double)attacker.m_20206_() * 0.75), (Number)0.0).vec3();
            Vec3 to = AnyPos.from((Vec3)target.m_20182_()).add((Number)0.0, (Number)((double)target.m_20206_() * 0.75), (Number)0.0).vec3();
            ParticleHandler.ENCHANTED_HIT.spawnLine(level, from, to, 5);
            SoundHandler.DRINK.play((Level)level, from, SoundHandler.randomized((float)0.25f));
        }
    }
}

